/*
 * hardware.h
 *
 *  Created on: Apr 3, 2013
 *      Author: G
 */

#ifndef HARDWARE_H_
#define HARDWARE_H_

#include <msp430.h>

#define     LED1                  BIT0
#define     LED2                  BIT6
#define     LED_DIR               P1DIR
#define     LED_OUT               P1OUT


#define     BUTTON                BIT3
#define     BUTTON_OUT            P1OUT
#define     BUTTON_DIR            P1DIR
#define     BUTTON_IN             P1IN
#define     BUTTON_IE             P1IE
#define     BUTTON_IES            P1IES
#define     BUTTON_IFG            P1IFG
#define     BUTTON_REN            P1REN

// P8.1 is SCLK
#define nRF8001_SCLK_PIN  BIT1
#define nRF8001_SCLK_POUT P8OUT
#define nRF8001_SCLK_PDIR P8DIR
#define nRF8001_SCLK_PSEL P8SEL
#define nRF8001_SCLK_PSEL2 P8SEL

// P8.3 is MISO. Note that on the
// Launchpad, P1.6 is also shared with
// an LED.
#define nRF8001_MISO_PIN  BIT3
#define nRF8001_MISO_POUT P8OUT
#define nRF8001_MISO_PDIR P8DIR
#define nRF8001_MISO_PSEL P8SEL
#define nRF8001_MISO_PSEL2 P8SEL

// P8.2 is MOSI
#define nRF8001_MOSI_PIN  BIT2
#define nRF8001_MOSI_POUT P8OUT
#define nRF8001_MOSI_PDIR P8DIR
#define nRF8001_MOSI_PSEL P8SEL
#define nRF8001_MOSI_PSEL2 P8SEL

// P4.3 is RDYN
#define nRF8001_RDYN_PIN   BIT3
#define nRF8001_RDYN_PINREG  P4IN
#define nRF8001_RDYN_POUT  P4OUT
#define nRF8001_RDYN_PDIR  P4DIR
#define nRF8001_RDYN_PSEL  P4SEL
#define nRF8001_RDYN_PSEL2 P4SEL
#define nRF8001_RDYN_PIES  P4IES
#define nRF8001_RDYN_PIFG  P4IFG
#define nRF8001_RDYN_PIE   P4IE

// P8.4 is REQN/CSN
#define nRF8001_REQN_CSN_PIN  BIT4
#define nRF8001_REQN_CSN_POUT P8OUT
#define nRF8001_REQN_CSN_PDIR P8DIR
#define nRF8001_REQN_CSN_PSEL P8SEL
#define nRF8001_REQN_CSN_PSEL2 P8SEL

// P4.1 is Reset
#define nRF8001_RST_PIN  BIT1
#define nRF8001_RST_POUT P4OUT
#define nRF8001_RST_PDIR P4DIR
#define nRF8001_RST_PSEL P4SEL
#define nRF8001_RST_PSEL2 P4SEL

// Board uses USCI UCA1 module
#define SPI_CTL0   UCA1CTL0
#define SPI_CTL1   UCA1CTL1
#define SPI_BR0    UCA1BR0
#define SPI_BR1    UCA1BR1
#define SPI_STAT   UCA1STAT
#define SPI_RX_BUF UCA1RXBUF
#define SPI_TX_BUF UCA1TXBUF

#define SPI_IFG    UCA1IFG
#define SPI_RX_IFG UCRXIFG
#define SPI_TX_IFG UCTXIFG

#endif /* HARDWARE_H_ */
